%% COMANDI DI PULIZIA E VISUALIZZAZIONE DATI
clc
clear all
close all
set(0,'defaultTextInterpreter','latex');          % serve a settare i grafici nei plot
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

load caratterizzazione_cilindro_completa.txt

m=10;
Fs=smooth(caratterizzazione_cilindro_completa(:,5),m);
Pr=smooth(caratterizzazione_cilindro_completa(:,7),m);
fs=20;
dt=1/fs;
t=[0:length(Pr)-1]*dt;
%% Plot curve considerando lo spostamento medio

figure
plot(Pr,Fs,'b','linewidth',2,'MarkerSize',8),
xlabel('Pressure $ \quad P_s \: (bar)$ rel'),ylabel('Force $ \quad F \: (N)$'),
grid on, zoom on
xlim([0 max(Pr)])
ylim([0 max(Fs)])
title('Andamento della forza applicata dal cilindro rispetto alla pressione')

figure
plot(t,Pr,'b','linewidth',2,'MarkerSize',8),
xlabel('Time $ \quad t \: (s)$'),ylabel('Pressure $ \quad P_s \: (bar)$ rel'), 
grid on, zoom on
xlim([0 max(t)])
ylim([0 max(Pr)])
title('Andamento della pressione nel tempo')


figure
plot(t,Fs,'b','linewidth',2,'MarkerSize',8),
xlabel('Time $ \quad t \: (s)$'),ylabel('Force $ \quad F \: (N)$'), 
grid on, zoom on
xlim([0 max(t)])
ylim([0 max(Fs)])
title('Andamento della forza nel tempo')

